<?php
/**
 * Created by PhpStorm.
 * User: timothy
 * Date: 2018/07/01
 * Time: 8:35 AM
 */

class Controller
{
	/**
	 *
	 */
	public static $BAD_REQ = 400;
	public static $BAD_AUTH = 401;
	public static $NOT_FOUND = 404;
	public static $TYPE_JSON = "Content-Type: application/json";
	public static $TYPE_HTML = "Content-Type: text/html; charset=iso-8859-1";
	public $silenced;
	public function __construct()
	{
	}

	/**
	 * @param array $vals
	 * @param array $cols
	 * @return array
	 */
	public static function valuate($vals, $cols)
	{
		foreach ($cols as $d) {
			array_push($vals, filter_input(INPUT_POST, $d,
				FILTER_SANITIZE_FULL_SPECIAL_CHARS) == null ? "" : filter_input(INPUT_POST, $d,
				FILTER_SANITIZE_FULL_SPECIAL_CHARS));
		}
		return $vals;
	}

	/**
	 * @param void
	 * @return string
	 */
	public static function valuesToString($cols)
	{
		$what = "";
		foreach ($cols as $d) {
			$what .= $d . "='" . filter_input(INPUT_POST, $d,
					FILTER_SANITIZE_FULL_SPECIAL_CHARS) . "',";
		}
		return substr($what, 0, strlen($what) - 1);
	}

	public static function setCols($cols)
	{
		$what = [];
		foreach ($cols as $d) {
			$input = filter_input(INPUT_POST, $d, FILTER_SANITIZE_SPECIAL_CHARS);
			if ($input != null || $input != "")
				array_push($what, $d);
		}
		return $what;
	}

	public static function input($var, $default, $type)
	{
		return (filter_input(INPUT_POST, $var, $type) != "" or
			filter_input(INPUT_POST, $var, $type) != null)
			? filter_input(INPUT_POST, $var, $type) : $default;
	}

	public function sendStatus($i)
	{
		switch($i){
			case 200:
				header( 'HTTP/1.0 200 OK' );
				break;
			case self::$BAD_REQ:
				$code = self::$BAD_REQ;
				header("HTTP/1.0 $code BAD REQUEST");
				break;
			case self::$BAD_AUTH:
				$code = self::$BAD_AUTH;
				header( "HTTP/1.0 $code BAD AUTH" );
				break;
			case self::$NOT_FOUND:
				$code = self::$NOT_FOUND;
				header( "HTTP/1.0 $code NOT FOUND");
				break;

		}
		flush();
		return $this;
	}

	public static function setCols_o($cols, $obj)
	{
		$what = [];
		foreach ($cols as $d) {
			$input = $obj[$d];
			if ($input != null || $input != "")
				array_push($what, $d);
		}
		return $what;
	}

	/**
	 * @param void
	 * @param void
	 * @return string
	 */
	public static function valuesToString_o($cols, $obj)
	{
		$what = "";
		foreach ($cols as $d) {
			$what .= $d . "='" . $obj[$d] . "',";
		}
		return substr($what, 0, strlen($what) - 1);
	}

	public static function valuate_o($vals, $cols, $obj)
	{
		foreach ($cols as $d) {
			array_push($vals, $obj[$d] == null ? "" : $obj[$d]);
		}
		return $vals;
	}
	public function silence($newArray,$arr){
		foreach($arr as $d){
			$val = true;
			foreach($this->silenced as $m){
				if ($m == $d){
					$val = false;
					break;
				}
			}
			if ($val) array_push($newArray,$d);
		}
		return $newArray;
	}
	public function hash($obj){
//		$obj = new ArrayObject($obj);
		if ($obj["password"]!=null||$obj["password"]!="")
			$obj["password"] = hash("sha256",$obj["password"]);
		if ($obj["pass_client"] != null||$obj["pass_client"]!="")
			$obj["pass_client"] = hash("sha256",$obj["pass_client"]);
		return $obj;
	}
	public static function io($obj,$var,$default=0){
		return  ($obj[$var]!=""||$obj[$var]!=null)?$obj[$var]:($default);
	}
	public static function mailer($email,$subject,$message,$from){
		$headers  = "From: $from < $from@dogmative.co.za >" . PHP_EOL;
		$headers .= "Cc: $from < $from@dogmative.co.za >" . PHP_EOL;
		$headers .= "X-Sender: $from < $from@dogmative.co.za > ". PHP_EOL;
		$headers .= 'X-Mailer: PHP/' . phpversion() . PHP_EOL;
		$headers .= "X-Priority: 1" . PHP_EOL; // Urgent message!
		$headers .= "Return-Path:   $from@dogmative.co.za" . PHP_EOL; // Return path for errors
		$headers .= "MIME-Version: 1.0" . PHP_EOL;
		$headers .= "Content-Type: text/html; charset=iso-8859-1" . PHP_EOL;
		return mail($email,$subject,$message,$headers);//,"-f $from@dogmative.co.za");
	}
}