<?php
/**
 * Created by PhpStorm.
 * User: timothy
 * Date: 2018/07/25
 * Time: 8:13 PM
 */

class FileMan extends Controller
{
	private $cols;
	private $col;
	private $tables;
	public $db;
	public function __construct()
	{
		$this->tables= ["dogmative_network.films"];
		$this->cols = [["name","concat(`name`,concat(' ',link)) as fullname",
			"`name`","`surname`","email","phone","phone","dob","country",
			'profilepic','id'],
			["link","synopsis","name","user_id","type_","poster","time_",
				"creation_date"]];
		$this->col = new User();
		$this->db = $this->col->db;
	}

	private function add_film($obj){
		$db = $this->db;
		$obj['time_'] = "now()";
		$obj['creation_date'] = "now()";
		$obj['poster'] = $obj['filebuilding'] . ".jpg";
		$col = $this->setCols_o($this->cols[1],$obj);
		$vls = Controller::valuate_o([],$col,$obj);
		$qry = Q_ueryBuild::insert($this->tables[0],$col,$vls);
		$stmt = $db->transaction($qry);
		$stmt->execute();
		return ["id"=>$db->db->lastInsertId()];
	}

	public function save_film($obj){
		$obj['filebuilding'] = substr(hash("sha256",$obj['filebuilding']),0,60)
			. ".". $obj['ext'];
		$this->write_file($obj,"filebuilding","data");
		if ($obj['exp'] >= $obj['chcksm']){
			$this->add_film($obj);
			$this->thumbnail($obj['filebuilding']);
		}
	}
	private function thumbnail($file){
		$cmd = "ffmpeg -ss 1 -i {$file} -vf thumbnail  -frames:v 1 {$file}.jpg";
		shell_exec($cmd);
	}
	public function update_pic($obj){
		$u = $this->col;
		$this->write_file($obj,'propic','data');
		$obj['name'] = 0;
		if ($obj['exp'] >= $obj['chcksm'])
			$u->update_expose($obj);
	}
	private function write_file($obj,$fs_,$data_){
		echo "['".$obj['exp'] . ":" . file_put_contents($obj[$fs_] , base64_decode($obj[$data_]), FILE_APPEND)
			. ":" . $obj['chcksm']."']'";
	}
	public function get_films($obj){
		$db = $this->db;
		$idStr = (($obj['id']!=""||$obj['id']!=null)?("id=" . $obj['id']):"1=1")
			. " limit "
			. Controller::io($obj,"start")
			. "," .  Controller::io($obj,"count",10);
		$qry = Q_ueryBuild::slct('*',$this->tables[0],$idStr);
		$stmt = $db->transaction($qry);
		$stmt->execute();
		return $stmt->fetchAll(PDO::FETCH_ASSOC);
	}
}